package com.burhanstore.neonbubblequest.Utils.adapter

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.burhanstore.neonbubblequest.AppConst.PAYMENT_IMG_PTAH
import com.burhanstore.neonbubblequest.R
import com.burhanstore.neonbubblequest.Utils.model.PaymentModel

class PaymentAdapter(
    private val items: List<PaymentModel>,
    private val onItemClick: (PaymentModel) -> Unit // click callback
) : RecyclerView.Adapter<PaymentAdapter.PaymentViewHolder>() {

    inner class PaymentViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val tvTitle: TextView = itemView.findViewById(R.id.textView15)
         val subtitle: TextView = itemView.findViewById(R.id.subtitle)
        //val tvRcoin: TextView = itemView.findViewById(R.id.coinUser)
        val ivLogo: ImageView = itemView.findViewById(R.id.icon)

        init {
            itemView.setOnClickListener {
                val position = adapterPosition
                if (position != RecyclerView.NO_POSITION) {
                    onItemClick(items[position])
                }
            }
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): PaymentViewHolder {
        val view = LayoutInflater.from(parent.context)
            .inflate(R.layout.item_payment_method, parent, false)
        return PaymentViewHolder(view)
    }

    override fun onBindViewHolder(holder: PaymentViewHolder, position: Int) {
        val item = items[position]
        holder.tvTitle.text = item.py_title
        val  py = item.py_title
    //    holder.tvAmount.text = item.py_currency + item.py_amout
        holder.subtitle.text = "Redeem $py using coins."
        item.py_logo?.let {
            Glide.with(holder.itemView.context)
                .load(PAYMENT_IMG_PTAH + it)
                .into(holder.ivLogo)
        }

    }

    override fun getItemCount(): Int = items.size
}
